/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.blocks.components;

import java.util.HashMap;
import minecrafttransportsimulator.baseclasses.Point3D;
import minecrafttransportsimulator.baseclasses.RotationMatrix;
import minecrafttransportsimulator.mcinterface.AWrapperWorld;

public abstract class ABlockBase {
    public static final float DEFAULT_HARDNESS = 1.5f;
    public static final float DEFAULT_BLAST_RESISTANCE = 6.0f;
    public final float hardness;
    public final float blastResistance;
    public static final HashMap<String, BlockMaterial> blockMaterialEnumMap = new HashMap();

    public ABlockBase(float hardness, float blastResistance) {
        this.hardness = hardness;
        this.blastResistance = blastResistance;
    }

    public void onBroken(AWrapperWorld world, Point3D position) {
    }

    public static enum BlockMaterial {
        DIRT,
        GLASS,
        GRASS,
        GRAVEL,
        ICE,
        LAVA,
        LEAVES,
        METAL,
        SAND,
        SNOW,
        STONE,
        WATER,
        WOOD,
        WOOL,
        NORMAL,
        CLAY,
        DIRT_WET,
        SAND_WET,
        NORMAL_WET;


        private BlockMaterial() {
            blockMaterialEnumMap.put(this.name(), this);
        }
    }

    public static enum Axis {
        NONE(0, 0, 0, 0, false, false),
        UP(0, 1, 0, 0, true, false),
        DOWN(0, -1, 0, 0, true, false),
        NORTH(0, 0, -1, 180, true, true),
        SOUTH(0, 0, 1, 0, true, true),
        EAST(1, 0, 0, 90, true, true),
        WEST(-1, 0, 0, 270, true, true),
        NORTHEAST(1, 0, -1, 135, false, true),
        SOUTHEAST(1, 0, 1, 45, false, true),
        NORTHWEST(-1, 0, -1, 225, false, true),
        SOUTHWEST(-1, 0, 1, 315, false, true);

        public final int xOffset;
        public final int yOffset;
        public final int zOffset;
        public final RotationMatrix yRotation;
        public final RotationMatrix facingRotation;
        public final boolean blockBased;
        public final boolean xzPlanar;

        private Axis(int xOffset, int yOffset, int zOffset, int yRotation, boolean blockBased, boolean xzPlanar) {
            this.xOffset = xOffset;
            this.yOffset = yOffset;
            this.zOffset = zOffset;
            this.yRotation = new RotationMatrix().setToAngles(new Point3D(0.0, yRotation, 0.0));
            this.facingRotation = new RotationMatrix().setToVector(new Point3D(xOffset, yOffset, zOffset), true);
            this.blockBased = blockBased;
            this.xzPlanar = xzPlanar;
        }

        public Point3D getOffsetPoint(Point3D point) {
            return point.copy().add(this.xOffset, this.yOffset, this.zOffset);
        }

        public Axis getOpposite() {
            switch (this) {
                case UP: {
                    return DOWN;
                }
                case DOWN: {
                    return UP;
                }
                case NORTH: {
                    return SOUTH;
                }
                case SOUTH: {
                    return NORTH;
                }
                case EAST: {
                    return WEST;
                }
                case WEST: {
                    return EAST;
                }
                case NORTHEAST: {
                    return SOUTHWEST;
                }
                case SOUTHEAST: {
                    return NORTHWEST;
                }
                case NORTHWEST: {
                    return SOUTHEAST;
                }
                case SOUTHWEST: {
                    return NORTHEAST;
                }
            }
            return NONE;
        }

        public static Axis getFromRotation(double rotation, boolean checkDiagonals) {
            if ((rotation %= 360.0) < 0.0) {
                rotation += 360.0;
            }
            int degRotation = (checkDiagonals ? (int)(Math.round(rotation / 45.0) * 45L) : (int)(Math.round(rotation / 90.0) * 90L)) % 360;
            for (Axis axis : Axis.values()) {
                if (!axis.xzPlanar || axis.yRotation.angles.y != (double)degRotation) continue;
                return axis;
            }
            return NONE;
        }

        public static Axis getFromVector(Point3D vector) {
            double xzVector = Math.hypot(vector.x, vector.z);
            double length = Math.hypot(xzVector, vector.y);
            xzVector /= length;
            double yVector = vector.y / length;
            if (yVector > 0.0) {
                if (yVector > xzVector) {
                    return UP;
                }
            } else if (-yVector > xzVector) {
                return DOWN;
            }
            if (vector.x < 0.0) {
                if (vector.z < 0.0) {
                    return -vector.x > -vector.z ? WEST : NORTH;
                }
                return -vector.x > vector.z ? WEST : SOUTH;
            }
            if (vector.z < 0.0) {
                return vector.x > -vector.z ? EAST : NORTH;
            }
            return vector.x > vector.z ? EAST : SOUTH;
        }
    }
}

